/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.mixin.aquiferfix;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.worldgen.context.AquiferContext;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegions;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegionsController;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6350;
import net.minecraft.class_6910;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_6350.class_5832.class})
public class AquiferMixin {
    @Unique
    private static int logCounter = 0;
    @Unique
    private static final int MAX_LOG_COUNTER = 20;
    @Unique
    private static boolean PRINTED_FINAL_ERROR = false;

    @Inject(method={"computeSubstance"}, at={@At(value="RETURN")}, cancellable=true)
    private void bettercaves$fixAquiferLiquids(class_6910.class_6912 context, double d, CallbackInfoReturnable<class_2680> cir) {
        if (logCounter > 20) {
            if (!PRINTED_FINAL_ERROR) {
                BetterCavesCommon.LOGGER.error("Failed to fetch the AquiferContext. Liquid Regions for YUNG's Better Caves may not generate properly.");
                BetterCavesCommon.LOGGER.error("This is a mod compatibility issue. Please report it to the Better Caves GitHub issue tracker!");
                PRINTED_FINAL_ERROR = true;
            }
            return;
        }
        AquiferContext aquiferContext = AquiferContext.peek();
        if (aquiferContext == null) {
            if (logCounter < 20) {
                BetterCavesCommon.LOGGER.warn("AquiferContext is null in AquiferMixin, this should not happen!");
            }
            ++logCounter;
            return;
        }
        class_3218 serverLevel = aquiferContext.getServerLevel();
        if (!LiquidRegionsController.getInstance().hasSettingsForLevel(serverLevel)) {
            return;
        }
        class_2680 blockState = (class_2680)cir.getReturnValue();
        if (blockState == null) {
            return;
        }
        class_1923 chunkPos = new class_1923(new class_2338(context.comp_371(), context.comp_372(), context.comp_373()));
        LiquidRegions liquidRegions = LiquidRegionsController.getInstance().getLiquidRegionsForServerLevel(serverLevel);
        LiquidRegions.CacheData cacheData = liquidRegions.getOrCreateLiquidBlocksForChunk(chunkPos);
        if (cacheData == null) {
            BetterCavesCommon.LOGGER.warn("No LiquidRegions data found for chunk {} in AquiferMixin, this should not happen!", (Object)chunkPos);
            return;
        }
        if (context.comp_372() > cacheData.liquidAltitude()) {
            return;
        }
        int localX = context.comp_371() & 0xF;
        int localZ = context.comp_373() & 0xF;
        class_2680 liquidBlock = cacheData.liquidBlocks()[localX][localZ];
        if (liquidBlock == null || !blockState.method_27852(liquidBlock.method_26204())) {
            cir.setReturnValue((Object)liquidBlock);
        }
    }
}

